#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Mouse JuliaMod01.fsh   by  sixstring982  
//https://www.shadertoy.com/view/lsyGR1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define ITERS 32

struct Window {
    float x;
    float y;
    float w;
    float h;
};

vec2 complexFromUv(in Window win, in vec2 uv) {
    return vec2(uv.x * win.w + win.x,
                uv.y * win.h + win.y);
}

vec3 palette(in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d) {
    return a + b*cos( 6.28318*(c*t+d) );
}

vec3 juliaPalette(in float t) {
    return palette(t, vec3(0.5, 0.5, 0.5), vec3(0.5, 0.5, 0.5), 
                      vec3(1.0, 1.0, 0.5), vec3(0.80, 0.90, 0.30));
}

vec3 mbrotPalette(in float t) {
    return palette(t, vec3(0.5, 0.5, 0.5), vec3(0.5, 0.5, 0.5), 
                      vec3(1.0, 1.0, 0.5), vec3(0.80, 0.90, 0.30));
}

float julia(in vec2 c, in vec2 z, in vec2 target) {
    float x;
    float d = 1e20;
    for (int j = 0; j < ITERS; j++) {
        if (z.x * z.x + z.y * z.y > 4.0) {
            return d;
        }
        
        x = z.x * z.x - z.y * z.y + c.x;
        z.y = 2.0 * z.x * z.y + c.y;
        z.x = x;
        
        d = min(d, length(z - target));
    }
    return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    Window win = Window(-2.0, -1.0, 3.0, 2.0);
	vec2 uv = fragCoord.xy / iResolution.xy;
    
    vec2 z = complexFromUv(win, uv);
    vec2 c = complexFromUv(win, iMouse.xy / iResolution.xy);
    
    vec2 t = vec2(sin(iTime) + 0.1 * sin(iTime * 2.0), 
                  cos(iTime) + 0.1 * cos(iTime * 2.0));
    
    t *= sin(iTime * 0.1) * 0.5;

    vec3 j = juliaPalette(pow(julia(c, z, t), 0.3));
    vec3 m = mbrotPalette(pow(julia(z, z, t), 0.7));
    float amt = 0.75 + 0.25 * sin(iTime * 0.1);
    fragColor = vec4(mix(m, j, amt), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

